<?php

/**
 * Initialize the custom theme options.
 */
add_action('init', 'custom_theme_options');

/**
 * Build the custom settings & update OptionTree.
 */
global $woocommerce;
 global $product;
function custom_theme_options()
{

	// OptionTree is not loaded yet, or this is not an admin request.
	if (!function_exists('ot_settings_id') || !is_admin()) {
		return false;
	}

	// Get a copy of the saved settings array.
	$saved_settings = get_option(ot_settings_id(), array());

	// Custom settings array that will eventually be passes to the OptionTree Settings API Class.
	$custom_settings = array(
		'contextual_help' => array(
			'sidebar' => '',
		),
		'sections'        => array(
			array(
				'id'    => 'general',
				'title' => esc_html__('عمومی', 'negarin'),
			),
			array(
				'id'    => 'logo_barsa',
				'title' => esc_html__('لوگو', 'negarin'),
			),
			array(
				'id'    => 'select_header_tab',
				'title' => esc_html__('سربرگ ', 'negarin'),
			),
			array(
				'id'    => 'blog',
				'title' => esc_html__('بلاگ', 'negarin'),
			),
			array(
				'id'    => 'cart_shop',
				'title' => esc_html__('سبد خرید', 'negarin'),
			),
			array(
				'id'    => 'menu_bar_single',
				'title' => esc_html__('منو محصول', 'negarin'),
			),
			array(
				'id'    => 'single_product_area',
				'title' => esc_html__('صفحه محصول', 'negarin'),
			),
			array(
				'id'    => 'single_product_tab',
				'title' => esc_html__('زبانه محصول', 'negarin'),
			),
			array(
				'id'    => 'back_to_top',
				'title' => esc_html__('بازگشت به بالا', 'negarin'),
			),
			array(
				'id'    => 'footer_shop',
				'title' => esc_html__('فوتر فروشگاه', 'negarin'),
			),
			array(
				'id'    => 'notification',
				'title' => esc_html__('اطلاعیه', 'negarin'),
			),
			array(
				'id'    => 'widget_shop',
				'title' => esc_html__('ابزارک', 'negarin'),
			),
			array(
				'id'    => 'post_single',
				'title' => esc_html__('نوشته ها', 'negarin'),
			),
			array(
				'id'    => 'advanced',
				'title' => esc_html__('پیشرفته', 'negarin'),
			),
		),
		'settings'        => array(
			array(
				'id'           => 'background_body_shop',
				'label'        => esc_html__('پس زمینه فروشگاه', 'negarin'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'background',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_question',
				'label'        => esc_html__('لینک سوالات', 'negarin'),
				'desc'         => esc_html__('لینک سوالات سربرگ موبایل', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_header',
				'label'        => 'انتخاب سربرگ',
				'desc'         => 'انتخاب سربرگ بصورت پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'header_nav_1',
						'label' => 'سربرگ یک',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_2',
						'label' => 'سربرگ دو',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_3',
						'label' => 'سربرگ سه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_4',
						'label' => 'سربرگ چهار',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_5',
						'label' => 'سربرگ پنج',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_classic',
				'label'        => 'انتخاب ویرایشگر ابزارک',
				'desc'         => 'انتخاب استایل و ویرایشگر ابزارک ها بصورت ، کلاسیک و گوتنبرگ',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'classic',
						'label' => 'کلاسیک',
						'src'   => '',
					),
					array(
						'value' => 'gutenberg',
						'label' => 'گوتنبرگ',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'phone_number_text',
				'label'        => esc_html__('شماره تلفن', 'negarin'),
				'desc'         => esc_html__('شماره تلفن یا ادرس ایمیل نمایش در سربرگ فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'item_arcive_product',
				'label'        => esc_html__('نمایش تعداد محصولات در آرشیو فروشگاه', 'negarin'),
				'desc'         => esc_html__('تعداد محصولاتی که در صفحه آرشیو نمایش داده می شوند', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_color_bth_add_to',
				'label'        => esc_html__('پس زمینه دکمه خرید', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه دکمه خرید در ویجت ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_color_bth_add_to_2',
				'label'        => esc_html__('رنگ متن دکمه خرید', 'negarin'),
				'desc'         => esc_html__('رنگ دکمه خرید در ویجت ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_color_bth_add_to_advance',
				'label'        => esc_html__(' پس زمینه دکمه خرید پیشرفته', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه دکمه خرید در ویجت ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_color_bth_add_to_2_advance',
				'label'        => esc_html__('رنگ متن دکمه خرید پیشرفته', 'negarin'),
				'desc'         => esc_html__('رنگ دکمه خرید در ویجت ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_add_to_cart_advance',
				'label'        => esc_html__('رنگ آیکون های دکمه خرید پیشرفته', 'negarin'),
				'desc'         => esc_html__('رنگ دکمه خرید در ویجت ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_sale_flash',
				'label'        => esc_html__(' متن درصد تخفیف', 'negarin'),
				'desc'         => esc_html__('انتخاب متن درصد تخفیف در صفحه محصول', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_sale_flash',
				'label'        => esc_html__(' پس زمینه درصد تخفیف', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه  درصد تخفیف در صفحه محصول', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_sale_flash_text',
				'label'        => esc_html__('  متن درصد تخفیف', 'negarin'),
				'desc'         => esc_html__('رنگ متن  درصد تخفیف در صفحه محصول', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'widget_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'logo_shop_barsa',
				'label'        => esc_html__('لوگو فروشگاه', 'negarin'),
				'desc'         => esc_html__('لوگو فروشگاه  (100 * 50) انتخاب کنید', 'negarin'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'logo_barsa',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_header',
				'label'        => esc_html__('سربرگ 2 , 1', 'liam'),
				'desc'         => esc_html__('سربرگ 2 , 1', 'liam'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar',
				'label'        => esc_html__('رنگ پس زمینه منو بار', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو بار فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__menu_bar',
				'label'        => esc_html__('فعال کردن منوبار', 'negarin'),
				'desc'         => esc_html__('فعال /غیر فعال کردن منو بار ', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar_share',
				'label'        => esc_html__('رنگ آیکون شبکه اجتماعی', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ آیکون شبکه اجتماعی منو بار فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header',
				'label'        => esc_html__('رنگ پس زمینه هدر', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'headershop_text_color',
				'label'        => esc_html__('رنگ متن سربرگ', 'negarin'),
				'desc'         => esc_html__('رنگ متن سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'bordercolor_searchbox_shop',
				'label'        => esc_html__('رنگ کادر جستجو', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ کادر جستجوی', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_border_profileshop',
				'label'        => esc_html__('رنگ حاشیه پروفایل', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه ورود کاربران', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'tab_shop_two_header_',
				'label'        => esc_html__('سربرگ 3', 'liam'),
				'desc'         => esc_html__('سربرگ 3', 'liam'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_two',
				'label'        => esc_html__('رنگ پس زمینه هدر', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'headershop_text_color_two',
				'label'        => esc_html__('رنگ متن سربرگ', 'negarin'),
				'desc'         => esc_html__('رنگ متن سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_icon_two',
				'label'        => esc_html__('رنگ پس زمینه آیکون ها', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه آیکون های سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_icon_cart_two',
				'label'        => esc_html__('رنگ پس زمینه سبد خرید', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه آیکون سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color__icon__two',
				'label'        => esc_html__('رنگ آیکون ها', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ  آیکون ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'telegram_link_text',
				'label'        => esc_html__('لینک تلگرام', 'negarin'),
				'desc'         => esc_html__('لینک تلگرام نمایش در سربرگ فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'tab_shop_three_header_',
				'label'        => esc_html__('سربرگ 4', 'liam'),
				'desc'         => esc_html__('سربرگ 4', 'liam'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_three',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'headershop_text_color_three',
				'label'        => esc_html__('رنگ متن سربرگ', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_back_menu_hashtag',
				'label'        => esc_html__('رنگ پس زمینه منو', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو هشتگ در سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_hashtag',
				'label'        => esc_html__('رنگ متن منو', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ متن منو هشتگ در سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_back_logo',
				'label'        => esc_html__('رنگ پس زمینه لوگو', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه لوگو در سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color__icon__header',
				'label'        => esc_html__('رنگ آیکون ها', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ  آیکون ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_menu_mobile',
				'label'        => esc_html__('رنگ آیکون منو موبایل', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ آیکون منو موبایل', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_profile_user',
				'label'        => esc_html__('لینک پنل کاربری ', 'negarin'),
				'desc'         => esc_html__('لینک پنل کاربری ، در صورت خالی بودن فیلد نمایش داده نخواهد شد.', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'tab_shop_five_header_',
				'label'        => esc_html__('سربرگ 5', 'liam'),
				'desc'         => esc_html__('سربرگ 5', 'liam'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__menu_bar_five',
				'label'        => esc_html__('فعال کردن منوبار', 'negarin'),
				'desc'         => esc_html__('فعال /غیر فعال کردن منو بار ', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar_five',
				'label'        => esc_html__('رنگ پس زمینه منو بار', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو بار فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar_share_five',
				'label'        => esc_html__('رنگ متن منو بار', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ آیکون شبکه اجتماعی و متن منو بار', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_five',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_five',
				'label'        => esc_html__('رنگ متن منو', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ متن منو  سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'border_bot_line',
				'label'        => esc_html__('رنگ خط متن وسط', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ خط متن وسط سربرگ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'select_header_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__product_offer',
				'label'        => esc_html__('محصولات', 'negarin'),
				'desc'         => esc_html__('فعال /غیر فعال کردن محصولات در صفحه نوشته ها', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_product_offer',
				'label'        => esc_html__('عنوان محصولات', 'negarin'),
				'desc'         => esc_html__('انتخاب متن عنوان محصولات در صفحه نوشته ها وبلاگ ', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_header_blog',
				'label'        => 'انتخاب سربرگ وبلاگ',
				'desc'         => 'انتخاب سربرگ بصورت پیش فرض وبلاگ',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'header_nav_blog_1',
						'label' => 'سربرگ یک',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_blog_2',
						'label' => 'سربرگ دو', 
						'src'   => '',
					),
					array(
						'value' => 'header_nav_blog_3',
						'label' => 'سربرگ سه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_blog_4',
						'label' => 'سربرگ چهار',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_blog_5',
						'label' => 'سربرگ پنج',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'item_arcive_blog',
				'label'        => esc_html__('نمایش تعداد پست ها در آرشیو وبلاگ', 'negarin'),
				'desc'         => esc_html__('نمایش تعداد پست ها در آرشیو وبلاگ', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'item_product_blog',
				'label'        => esc_html__('نمایش تعداد محصولات', 'negarin'),
				'desc'         => esc_html__('نمایش تعداد محصولات در صفحه نوشته ها', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'          => 'category_select_product_2',
				'label'       => __( 'انتخاب دسته بندی', 'negarin' ),
				'desc'        => __( 'انتخاب دسته بندی محصولات در صفحه نوشته وبلاگ', 'negarin' ),
				'std'         => '',
				'type'        => 'taxonomy-select',
				'section'     => 'blog',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => 'product_cat',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			  ),
			  array(
				'id'           => 'select_orderby_product',
				'label'        => 'مرتب سازی',
				'desc'         => 'مرتب سازی محصولات برا اساس محبوب ، اخیر ، تخفیف دار',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'product_lately',
						'label' => 'محصولات اخیر',
						'src'   => '',
					),
					array(
						'value' => 'product_sale',
						'label' => 'محصولات با تخفیف',
						'src'   => '',
					),
					/* array(
						'value' => 'product_popular',
						'label' => 'محصولات محبوب',
						'src'   => '',
					),*/
				),
			),
			array(
				'id'           => 'sidbar_cart_shop',
				'label'        => esc_html__('رنگ پس زمینه تعداد ', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه تعداد محصول انتخابی در سایدبار سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'cart_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'sidbar_cart_shop_total',
				'label'        => esc_html__('رنگ پس زمینه مجموع خرید', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه مجموع محصولات در سایدبار سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'cart_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'sidbar_cart_shop_total_text_color',
				'label'        => esc_html__('رنگ متن قیمت کل', 'negarin'),
				'desc'         => esc_html__('رنگ متن قیمت کل در سایدبار سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'cart_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'sidbar_cart_shop_checkout',
				'label'        => esc_html__('رنگ پس زمینه تسویه حساب', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه تسویه حساب در سایدبار سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'cart_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'sidbar_cart_shop_checkout_text',
				'label'        => esc_html__('رنگ  متن تسویه حساب', 'negarin'),
				'desc'         => esc_html__('رنگ متن تسویه حساب در سایدبار سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'cart_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'sidbar_cart_shop_forward',
				'label'        => esc_html__('رنگ پس زمینه سبد خرید', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه سبد خرید در سایدبار سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'cart_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'sidbar_cart_shop_forward_text',
				'label'        => esc_html__('رنگ  متن سبد خرید', 'negarin'),
				'desc'         => esc_html__('رنگ متن سبد خرید در سایدبار سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'cart_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'show_color_menu_bar',
				'label'        => esc_html__('فعال کردن منو', 'negarin'),
				'desc'         => esc_html__('فعال /غیر فعال کردن منو در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'menu_bar_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'back_color_menu_bar',
				'label'        => esc_html__('رنگ پس زمینه', 'negarin'),
				'desc'         => esc_html__('رنگ پس زمینه منو در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'menu_bar_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_active_menu_bar',
				'label'        => esc_html__('رنگ آیکون منو', 'negarin'),
				'desc'         => esc_html__('رنگ آیکون منو در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'menu_bar_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__product_offer_single',
				'label'        => esc_html__('محصولات ', 'negarin'),
				'desc'         => esc_html__('فعال /غیر فعال کردن محصولات در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__post_single',
				'label'        => esc_html__('مقالات', 'negarin'),
				'desc'         => esc_html__('فعال /غیر فعال کردن نوشته ها در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_add_to_cart',
				'label'        => 'انتخاب دکمه افزودن به سید خرید',
				'desc'         => 'انتخاب دکمه افزودن به سید خرید در صفحه محصول',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'select_add_to_cart_simple',
						'label' => 'ساده',
						'src'   => '',
					),
					array(
						'value' => 'select_add_to_cart_advanced',
						'label' => 'پیشرفته',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'btn_add_to_cart',
				'label'        => esc_html__('رنگ دکمه خرید', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ دکمه خرید صفحه محصول', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'wo_product__seller_info',
				'label'        => esc_html__('رنگ باکس مشخصات خرید ', 'negarin'),
				'desc'         => esc_html__('انتخاب پس زمینه مشخصات خرید در صفحه محصول', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_info_text_prouct_cart',
				'label'        => esc_html__('متن رنگ مشخصات خرید', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ متن مشخصات خرید  صفحه محصول', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_price_prouct',
				'label'        => esc_html__('رنگ متن قیمت محصول', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ متن قیمت در صفحه محصول ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_product_offer_single',
				'label'        => esc_html__('عنوان محصولات', 'negarin'),
				'desc'         => esc_html__('انتخاب متن عنوان محصولات در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'titlemore_product_offer_single',
				'label'        => esc_html__('مشاهده بیشتر محصولات', 'negarin'),
				'desc'         => esc_html__('انتخاب متن مشاهده بیشتر محصولات در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'titlemorelink_product_offer_single',
				'label'        => esc_html__('لینک مشاهده بیشتر محصولات ', 'negarin'),
				'desc'         => esc_html__('انتخاب لینک مشاهده بیشتر محصولات در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'item_product_blog_single',
				'label'        => esc_html__('نمایش تعداد محصولات', 'negarin'),
				'desc'         => esc_html__('نمایش تعداد محصولات در صفحه داخلی محصولات', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'          => 'category_select_product_2_single',
				'label'       => __( 'انتخاب دسته بندی', 'negarin' ),
				'desc'        => __( 'انتخاب دسته بندی محصولات در صفحه داخلی محصولات', 'negarin' ),
				'std'         => '',
				'type'        => 'taxonomy-select',
				'section'     => 'single_product_area',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => 'product_cat',
				'min_max_step'=> '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			  ),
			  array(
				'id'           => 'select_orderby_product_single',
				'label'        => 'مرتب سازی',
				'desc'         => 'مرتب سازی محصولات برا اساس محبوب ، اخیر ، تخفیف دار',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'product_lately',
						'label' => 'محصولات اخیر',
						'src'   => '',
					),
					array(
						'value' => 'product_sale',
						'label' => 'محصولات با تخفیف',
						'src'   => '',
					),
					/* array(
						'value' => 'product_popular',
						'label' => 'محصولات محبوب',
						'src'   => '',
					),*/
				),
			),
			array(
				'id'           => 'single_text_read_more',
				'label'        => esc_html__('عنوان مقالات ', 'liosa'),
				'desc'         => esc_html__('انتخاب عنوان بیشتر بخوانید در صفحه داخلی محصولات', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'single_item_read_more',
				'label'        => esc_html__('تعداد مطالب ', 'liosa'),
				'desc'         => esc_html__('انتخاب تعداد مطالب ،بیشتر بخوانید در صفحه داخلی محصولات', 'liosa'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'single_product_area',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'          => 'single_category_select_id_1',
				'label'       => __('انتخاب دسته بندی ', 'liosa'),
				'desc'        => __('انتخاب دسته بندی مقالات در صفحه داخلی محصولات', 'liosa'),
				'std'         => '',
				'type'        => 'category-select',
				'section'     => 'single_product_area',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step' => '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'           => 'color_background_tab',
				'label'        => esc_html__('رنگ پس زمینه', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه تب منو در صفحه محصول ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'single_product_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_tab',
				'label'        => esc_html__('رنگ متن منو', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ متن تب منو در صفحه محصول ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'single_product_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_active_tab',
				'label'        => esc_html__('رنگ فعال شدن تب', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ فعال شدن تب منو در صفحه محصول ', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'single_product_tab',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_call_back_to_top',
				'label'        => esc_html__('لینک تماس', 'negarin'),
				'desc'         => esc_html__('انتخاب لینک تماس به ما یا لینک تلگرام ، واتساپ و...', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_call_back_to_top',
				'label'        => esc_html__('متن نگهدارنده تماس', 'negarin'),
				'desc'         => esc_html__('انتخاب شماره تماس  یا ایدی تلگرام ، واتساپ و...', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_background_back_to_top',
				'label'        => esc_html__('رنگ پس زمینه', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_back_to_top',
				'label'        => esc_html__('رنگ آیکون ها', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_hover_back_to_top',
				'label'        => esc_html__('رنگ پس زمینه هاور ', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه هاور شدن دکمه ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_hover_text_back_to_top',
				'label'        => esc_html__('رنگ  متن هاور ', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ  متن هنگام هاور شدن دکمه ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_cart_back',
				'label'        => esc_html__('نمایش سبد خرید', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه سبد خرید', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_notification_back',
				'label'        => esc_html__('نمایش اطلاعیه', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه اطلاعیه', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_call_back',
				'label'        => esc_html__('نمایش تماس باما', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه تماس با ما', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_back_to_top',
				'label'        => esc_html__('نمایش بازگشت به بالا', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه بازگشت به بالا', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_notification',
				'label'        => esc_html__('نمایش اطلاعیه ', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن اطلاعیه ', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'background_notification',
				'label'        => esc_html__('پس زمینه فروشگاه', 'negarin'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'background',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_notification',
				'label'        => esc_html__('لینک اطلاعیه', 'negarin'),
				'desc'         => esc_html__('انتخاب لینک اطلاعیه در بالای صفحه', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_link_notification',
				'label'        => esc_html__('متن لینک اطلاعیه', 'negarin'),
				'desc'         => esc_html__('انتخاب  متن لینک اطلاعیه در بالای صفحه', 'negarin'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_notification',
				'label'        => esc_html__('متن اطلاعیه', 'negarin'),
				'desc'         => esc_html__('انتخاب متن اطلاعیه در بالای صفحه', 'negarin'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_background_notification_bth',
				'label'        => esc_html__('رنگ پس زمینه دکمه', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه در اطلاعیه در بالای صفحه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_notification',
				'label'        => esc_html__('رنگ متن دکمه', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ متن دکمه در اطلاعیه در بالای صفحه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_notification_close',
				'label'        => esc_html__('رنگ آیکون خروج', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ آیکون دکمه خروج در اطلاعیه در بالای صفحه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'notification_height_pc',
				'label'        => esc_html__(' عرض اطلاعیه دسکتاپ ', 'negarin'),
				'desc'         => esc_html__('انتخاب عرض اطلاعیه دسکتاپ ', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '-1,500,1',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'notification_height_mobile',
				'label'        => esc_html__(' عرض اطلاعیه موبایل', 'negarin'),
				'desc'         => esc_html__('انتخاب عرض اطلاع موبایل ', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'notification',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '-1,500,1',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__footerr',
				'label'        => esc_html__('فعال کردن فوتر', 'negarin'),
				'desc'         => esc_html__('فعال /غیر فعال کردن فوتر ', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'footer_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'background_footer_shop',
				'label'        => esc_html__('پس زمینه فوتر فروشگاه', 'negarin'),
				'desc'         => esc_html__('پس زمینه فوتر فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'background',
				'section'      => 'footer_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'copyright_footerhop',
				'label'        => esc_html__('کپی رایت', 'negarin'),
				'desc'         => esc_html__('کپی رایت فوتر فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'footer_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'or',
			),
			array(
				'id'           => 'title__footer_shop',
				'label'        => esc_html__('رنگ عنوان ویجت ها', 'negarin'),
				'desc'         => esc_html__('رنگ عنوان ویجت ها در فوتر فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'all_text__footer_shop',
				'label'        => esc_html__('رنگ متن فوتر', 'negarin'),
				'desc'         => esc_html__('رنگ متن کلی فوتر فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'copy_right_shopfo',
				'label'        => esc_html__('رنگ پس زمینه کپی رایت', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه فوتر فروشگاه', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_links_shop',
				'label'        => esc_html__('شبکه اجتماعی', 'negarin'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'social-links',
				'section'      => 'footer_shop',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_img',
				'label'        => esc_html__(' عرض تصاویر', 'negarin'),
				'desc'         => esc_html__('تمام عرض / استاندارد سایز تصاویر در پست نوشته ها', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_color',
				'label'        => esc_html__('رنگ نوشته ', 'negarin'),
				'desc'         => esc_html__('انتخاب رنگ پست نوشته ها', 'negarin'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_number_related',
				'label'        => esc_html__('مطالب مرتبط ', 'negarin'),
				'desc'         => esc_html__('انتخاب تعداد مطالب مرتبط در صفحه نوشته', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_font_size',
				'label'        => esc_html__(' فونت نوشته ', 'negarin'),
				'desc'         => esc_html__('انتخاب سایز پست نوشته', 'negarin'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'avatar_name',
				'label'        => esc_html__('نام نویسنده', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن نام نویسنده', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_viwe',
				'label'        => esc_html__('تعداد بازدید', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تعداد بازدید', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_time',
				'label'        => esc_html__('تاریخ نوشته', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تاریخ نوشته', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_share',
				'label'        => esc_html__('اشتراک گذاری', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن اشتراک گذاری', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'comments_number',
				'label'        => esc_html__('تعداد کامنت', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تعداد کامنت', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'd_category',
				'label'        => esc_html__('دسته بندی ها', 'negarin'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دسته بندی ها', 'negarin'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'comment_rules',
				'label'        => esc_html__('قوانین نظرات', 'negarin'),
				'desc'         => esc_html__('متن قوانین ارسال دیدگاه ، قوانین بصورت لیست نوشته شود و از ul > li استفاده کنید.', 'negarin'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'add_css_advan',
				'label'        => esc_html__('css سفارشی', 'negarin'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'css',
				'section'      => 'advanced',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
		)
	);

	// Allow settings to be filtered before saving.
	$custom_settings = apply_filters(ot_settings_id() . '_args', $custom_settings);

	// Settings are not the same update the DB.
	if ($saved_settings !== $custom_settings) {
		update_option(ot_settings_id(), $custom_settings);
	}

	// Lets OptionTree know the UI Builder is being overridden.
	global $ot_has_custom_theme_options;
	$ot_has_custom_theme_options = true;
	$select_classic = ot_get_option('select_classic');
	if ($select_classic == 'classic') {
	add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
	add_filter( 'use_widgets_block_editor', '__return_false' );
	}
}
