<?php

/*-----------------------------------------------------------------------------------*/
# Get Theme Options
/*-----------------------------------------------------------------------------------*/
function tie_get_option( $name ) {
	$get_options = get_option( 'tie_options' );

	if( !empty( $get_options[$name] ))
		 return $get_options[$name];

	return false ;
}
/*-----------------------------------------------------------------------------------*/
# Get score
/*-----------------------------------------------------------------------------------*/
function tie_get_score( $post_id = false , $size = 'small'){
	if(function_exists('taqyeem_get_score')) {
		taqyeem_get_score( $post_id , $size );
	}
}
/*-----------------------------------------------------------------------------------*/
# Get Post Video
/*-----------------------------------------------------------------------------------*/
function tie_video(){
 $wp_embed = new WP_Embed();
	global $post;
	$get_meta = get_post_custom($post->ID);
	if( !empty( $get_meta["tie_video_url"][0] ) ){
		$video_url = $get_meta["tie_video_url"][0];

		$protocol = is_ssl() ? 'https' : 'http';
		if( !is_ssl() ){
			$video_url = str_replace ( 'https://', 'http://', $video_url );
		}
		$video_output = $wp_embed->run_shortcode('[embed width="660" height="371.25"]'.$video_url.'[/embed]');
		if( $video_output == '<a href="'.$video_url.'">'.$video_url.'</a>' ){
			$width  = '660' ;
			$height = '371.25';
			$video_link = @parse_url($video_url);
			if ( $video_link['host'] == 'www.youtube.com' || $video_link['host']  == 'youtube.com' ) {
				parse_str( @parse_url( $video_url, PHP_URL_QUERY ), $my_array_of_vars );
				$video =  $my_array_of_vars['v'] ;
				$video_output ='<iframe width="'.$width.'" height="'.$height.'" src="'.$protocol.'://www.youtube.com/embed/'.$video.'?rel=0&wmode=opaque" frameborder="0" allowfullscreen></iframe>';
			}
			elseif( $video_link['host'] == 'www.youtu.be' || $video_link['host']  == 'youtu.be' ){
				$video = substr(@parse_url($video_url, PHP_URL_PATH), 1);
				$video_output ='<iframe width="'.$width.'" height="'.$height.'" src="'.$protocol.'://www.youtube.com/embed/'.$video.'?rel=0&wmode=opaque" frameborder="0" allowfullscreen></iframe>';
			}elseif( $video_link['host'] == 'www.vimeo.com' || $video_link['host']  == 'vimeo.com' ){
				$video = (int) substr(@parse_url($video_url, PHP_URL_PATH), 1);
				$video_output='<iframe src="'.$protocol.'://player.vimeo.com/video/'.$video.'?wmode=opaque" width="'.$width.'" height="'.$height.'" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';
			}
			elseif( $video_link['host'] == 'www.dailymotion.com' || $video_link['host']  == 'dailymotion.com' ){
				$video = substr(@parse_url($video_url, PHP_URL_PATH), 7);
				$video_id = strtok($video, '_');
				$video_output='<iframe frameborder="0" width="'.$width.'" height="'.$height.'" src="'.$protocol.'://www.dailymotion.com/embed/video/'.$video_id.'"></iframe>';
			}
			else{
				$video_output = do_shortcode( '[video width="1280" height="720" mp4="'. $video_url .'"][/video]' );
			}
		}
	}
	elseif( !empty( $get_meta["tie_embed_code"][0] ) ){
		$embed_code = $get_meta["tie_embed_code"][0];
		$video_output = htmlspecialchars_decode( $embed_code);
	}
	elseif( !empty( $get_meta["tie_video_self"][0] ) ){
		$video_self = $get_meta["tie_video_self"][0];
		$video_output = do_shortcode( '[video width="1280" height="720" mp4="'.$get_meta["tie_video_self"][0].'"][/video]' );
	}
	if( !empty($video_output) ) echo $video_output; ?>
<?php
}


/*-----------------------------------------------------------------------------------*/
# Post Video embed URL
/*-----------------------------------------------------------------------------------*/
function tie_video_embed(){
	global $post;
	$get_meta = get_post_custom($post->ID);
	if( !empty( $get_meta["tie_video_url"][0] ) ){
		$video_output = tie_get_video_embed( $get_meta["tie_video_url"][0] );
	}
	if( !empty($video_output) ) return $video_output;
	else return home_url( '/' ); ?>
<?php
}


/*-----------------------------------------------------------------------------------*/
# Get Video embed URL
/*-----------------------------------------------------------------------------------*/
function tie_get_video_embed( $video_url ){
	$protocol = is_ssl() ? 'https' : 'http';
	$video_link = @parse_url($video_url);
	if ( $video_link['host'] == 'www.youtube.com' || $video_link['host']  == 'youtube.com' ) {
		parse_str( @parse_url( $video_url, PHP_URL_QUERY ), $my_array_of_vars );
		$video =  $my_array_of_vars['v'] ;
		$video_output = $protocol.'://www.youtube.com/embed/'.$video.'?rel=0&wmode=opaque&autohide=1&border=0&egm=0&showinfo=0';
	}
	elseif( $video_link['host'] == 'www.youtu.be' || $video_link['host']  == 'youtu.be' ){
		$video = substr(@parse_url($video_url, PHP_URL_PATH), 1);
		$video_output = $protocol.'://www.youtube.com/embed/'.$video.'?rel=0&wmode=opaque&autohide=1&border=0&egm=0&showinfo=0';
	}elseif( $video_link['host'] == 'www.vimeo.com' || $video_link['host']  == 'vimeo.com' ){
		$video = (int) substr(@parse_url($video_url, PHP_URL_PATH), 1);
		$video_output= $protocol.'://player.vimeo.com/video/'.$video.'?wmode=opaque';
	}else{
		$video_output = $video_url;
	}

	if( !empty($video_output) ) return $video_output; ?>
<?php
}


/*-----------------------------------------------------------------------------------*/
# Get Most Recent posts
/*-----------------------------------------------------------------------------------*/
function tie_last_posts($posts_number = 5 , $thumb = true){
	global $post;
	$original_post = $post;

	$args = array(
		'posts_per_page'		 => $posts_number,
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$get_posts_query = new WP_Query( $args );

	if ( $get_posts_query->have_posts() ):
		while ( $get_posts_query->have_posts() ) : $get_posts_query->the_post()?>
		<li <?php tie_post_class(); ?>>
			<?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() && $thumb ) : ?>
				<a target="_blank" class="inner-card lazy-hoarea" href="<?php the_permalink(); ?>"rel="bookmark">
					<img class="card-box"<?php the_post_thumbnail( 'singlenavigation' ); ?>
				<?php endif; ?>
					<span class="card-title"><?php the_title();?></span>
				</a>
		</li>
		<?php
		endwhile;
	endif;

	$post = $original_post;
	wp_reset_query();
}


/*-----------------------------------------------------------------------------------*/
# Get Most Recent posts from Category
/*-----------------------------------------------------------------------------------*/
function tie_last_posts_cat($posts_number = 5 , $thumb = true , $cats = 1){
	global $post;
	$original_post = $post;

	$args = array(
		'posts_per_page'		 => $posts_number,
		'cat'					 => $cats,
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$get_posts_query = new WP_Query( $args );

	if ( $get_posts_query->have_posts() ):
		while ( $get_posts_query->have_posts() ) : $get_posts_query->the_post()?>
		<li <?php tie_post_class(); ?>>
			<?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() && $thumb ) : ?>
				<a target="_blank" class="inner-card lazy-hoarea" href="<?php the_permalink(); ?>"rel="bookmark">
					<img class="card-box"<?php the_post_thumbnail( 'singlenavigation' ); ?>
			<?php endif; ?>
					<span class="card-title"><?php the_title();?></span>
				</a>
		</li>
		<?php
		endwhile;
	endif;

	$post = $original_post;
	wp_reset_query();
}
/*-----------------------------------------------------------------------------------*/
# Get Most Recent posts from Category - Timeline
/*-----------------------------------------------------------------------------------*/
function tie_last_posts_cat_timeline($posts_number = 5 , $cats = 1){
	global $post;
	$original_post = $post;

	$args = array(
		'posts_per_page'		 => $posts_number,
		'cat'					 => $cats,
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$get_posts_query = new WP_Query( $args );

	if ( $get_posts_query->have_posts() ):
		while ( $get_posts_query->have_posts() ) : $get_posts_query->the_post()?>
		<li>
			<a target="_blank" href="<?php the_permalink(); ?>">
				<?php tie_get_time() ?>
				<h3><?php the_title();?></h3>
			</a>
		</li>
		<?php
		endwhile;
	endif;

	$post = $original_post;
	wp_reset_query();
}

/*-----------------------------------------------------------------------------------*/
# Get Most Recent posts from Category with Authors
/*-----------------------------------------------------------------------------------*/
function tie_last_posts_cat_authors($posts_number = 5 , $thumb = true , $cats = 1){
	global $post;
	$original_post = $post;

	$args = array(
		'posts_per_page'		 => $posts_number,
		'cat'					 => $cats,
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$get_posts_query = new WP_Query( $args );

	if ( $get_posts_query->have_posts() ):
		while ( $get_posts_query->have_posts() ) : $get_posts_query->the_post()?>
		<li>
			<?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() && $thumb ) : ?>
				<div class="post-thumbnail">
					<a target="_blank" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) )?>" title=""><?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'MFW_author_bio_avatar_size', 50 ) ); ?></a>
				</div><!-- post-thumbnail /-->
			<?php endif; ?>
			<h3><a target="_blank" href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
			<strong><a target="_blank" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) )?>" title=""><?php echo get_the_author() ?> </a></strong>
		</li>
		<?php
		endwhile;
	endif;

	$post = $original_post;
	wp_reset_query();
}


/*-----------------------------------------------------------------------------------*/
# Get Random posts
/*-----------------------------------------------------------------------------------*/
function tie_random_posts($posts_number = 5 , $thumb = true){
	global $post;
	$original_post = $post;

	$args = array(
		'posts_per_page'		 => $posts_number,
		'orderby'				 => 'rand',
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$get_posts_query = new WP_Query( $args );

	if ( $get_posts_query->have_posts() ):
		while ( $get_posts_query->have_posts() ) : $get_posts_query->the_post()?>
		<li <?php tie_post_class(); ?>>
			<?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() && $thumb ) : ?>
				<a target="_blank" class="inner-card lazy-hoarea" href="<?php the_permalink(); ?>"rel="bookmark">
					<img class="card-box"<?php the_post_thumbnail( 'singlenavigation' ); ?>
			<?php endif; ?>
					<span class="card-title"><?php the_title();?></span>
				</a>
		</li>
		<?php
		endwhile;
	endif;

	$post = $original_post;
	wp_reset_query();
}

/*-----------------------------------------------------------------------------------*/
# Get Popular posts
/*-----------------------------------------------------------------------------------*/
function tie_popular_posts( $posts_number = 5 , $thumb = true){
	global $post;
	$original_post = $post;

	$args = array(
		'orderby'				 => 'comment_count',
		'order'					 => 'DESC',
		'posts_per_page'		 => $posts_number,
		'post_status'			 => 'publish',
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$popularposts = new WP_Query( $args );
	if ( $popularposts->have_posts() ):
		while ( $popularposts->have_posts() ) : $popularposts->the_post()?>
		<li <?php tie_post_class(); ?>>
			<?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() && $thumb ) : ?>
				<a target="_blank" class="inner-card lazy-hoarea" href="<?php the_permalink(); ?>"title="<?php the_title_attribute( ) ?>"rel="bookmark">
					<img class="card-box"<?php the_post_thumbnail( 'singlenavigation' ); ?>
			<?php endif; ?>
					<span class="card-title"><?php the_title();?></span>
				</a>
		</li>
	<?php
		endwhile;
	endif;





	$post = $original_post;
	wp_reset_query();
}

/*-----------------------------------------------------------------------------------*/
# Get Popular posts / Views
/*-----------------------------------------------------------------------------------*/
function tie_most_viewed( $posts_number = 5 , $thumb = true){
	global $post;
	$original_post = $post;

	$args = array(
		'orderby'				 => 'meta_value_num',
		'meta_key'				 => 'tie_views',
		'posts_per_page'		 => $posts_number,
		'post_status'			 => 'publish',
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$popularposts = new WP_Query( $args );
	if ( $popularposts->have_posts() ):
		while ( $popularposts->have_posts() ) : $popularposts->the_post()?>
		<li <?php tie_post_class(); ?>>
			<?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() && $thumb ) : ?>
				<a target="_blank" class="inner-card lazy-hoarea" href="<?php echo get_permalink( $post->ID ) ?>"title=" <?php the_title_attribute() ?>"rel="bookmark">
					<img class="card-box"<?php the_post_thumbnail( 'singlenavigation' ); ?>
			<?php endif; ?>
					<span class="card-title"><?php the_title();?></span>
				</a>
		</li>
	<?php
		endwhile;
	endif;
	$post = $original_post;
	wp_reset_query();
}


/*-----------------------------------------------------------------------------------*/
# Get Most commented posts
/*-----------------------------------------------------------------------------------*/
function tie_most_commented($comment_posts = 5 , $avatar_size = 55){
$comments = get_comments('status=approve&number='.$comment_posts);
foreach ($comments as $comment) { ?>
	<li>
		<div class="post-thumbnail" style="width:<?php echo $avatar_size ?>px">
			<?php echo get_avatar( $comment, $avatar_size ); ?>
		</div>
		<a href="<?php echo get_permalink($comment->comment_post_ID ); ?>#comment-<?php echo $comment->comment_ID; ?>">
		<?php echo strip_tags($comment->comment_author); ?>: <?php echo wp_html_excerpt( $comment->comment_content, 80 ); ?>... </a>
	</li>
<?php }
}

/*-----------------------------------------------------------------------------------*/
# Get Best Reviews posts
/*-----------------------------------------------------------------------------------*/
function tie_best_reviews_posts( $posts_number = 5 , $thumb = true){
	global $post;
	$original_post = $post;

	$args = array(
		'orderby'				 => 'meta_value_num',
		'meta_key'				 => 'taq_review_score',
		'posts_per_page'		 => $posts_number,
		'post_status'			 => 'publish',
		'no_found_rows'          => true,
		'ignore_sticky_posts'	 => true
	);

	$best_views = new WP_Query( $args );

	if ( $best_views->have_posts() ):
		while ( $best_views->have_posts() ) : $best_views->the_post()?>
		<li <?php tie_post_class(); ?>>
			<?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() && $thumb ) : ?>
				<a target="_blank" class="inner-card lazy-hoarea" href="<?php the_permalink(); ?>"rel="bookmark">
					<img class="card-box"<?php the_post_thumbnail( 'singlenavigation' ); ?>
			<?php endif; ?>
					<span class="card-title"><?php the_title();?></span>
				</a>
		</li>
<?php
		endwhile;
	endif;

	$post = $original_post;
	wp_reset_query();
}


/*-----------------------------------------------------------------------------------*/
# OG Meta for posts
/*-----------------------------------------------------------------------------------*/
function tie_og_data() {
	global $post ;

	if ( function_exists("has_post_thumbnail") && has_post_thumbnail() )
		$post_thumb = tie_thumb_src( 'slider' ) ;
	else{
		$protocol = is_ssl() ? 'https' : 'http';
		$get_meta = get_post_custom($post->ID);
		if( !empty( $get_meta["tie_video_url"][0] ) ){
			$video_url = $get_meta["tie_video_url"][0];
			$video_link = @parse_url($video_url);
			if ( $video_link['host'] == 'www.youtube.com' || $video_link['host']  == 'youtube.com' ) {
				parse_str( @parse_url( $video_url, PHP_URL_QUERY ), $my_array_of_vars );
				$video =  $my_array_of_vars['v'] ;
				$post_thumb = $protocol.'://img.youtube.com/vi/'.$video.'/0.jpg';
			}
			elseif( $video_link['host'] == 'www.vimeo.com' || $video_link['host']  == 'vimeo.com' ){
				$video = (int) substr(@parse_url($video_url, PHP_URL_PATH), 1);
				$url = $protocol.'://vimeo.com/api/v2/video/'.$video.'.php';;
				$contents = @file_get_contents($url);
				$thumb = @unserialize(trim($contents));
				$post_thumb = $thumb[0]['thumbnail_large'];
			}
		}
	}

$og_title 		= strip_shortcodes(strip_tags(( get_the_title() ))) .' - '. get_bloginfo('name') ;
$og_description = strip_tags(strip_shortcodes( apply_filters('tie_exclude_content', $post->post_content) ) );
$og_type 		= 'article';

if( is_home() || is_front_page() ){
	$og_title 		= get_bloginfo('name');
	$og_description = get_bloginfo( 'description' );
	$og_type 		= 'website';
}

?>
<meta property="og:title" content="<?php echo $og_title ?>"/>
<meta property="og:type" content="<?php echo $og_type ?>"/>
<meta property="og:description" content="<?php echo wp_html_excerpt( $og_description , 100 ) ?>"/>
<meta property="og:url" content="<?php the_permalink(); ?>"/>
<meta property="og:site_name" content="<?php echo get_bloginfo( 'name' ) ?>"/>
<?php
if( !empty($post_thumb) )
	echo '<meta property="og:image" content="'. $post_thumb .'" />'."\n";
}


/*-----------------------------------------------------------------------------------*/
# Get the post time
/*-----------------------------------------------------------------------------------*/
function tie_get_time( $return = false ){
	global $post ;

	if( tie_get_option( 'time_format' ) == 'none' ){
		return false;

	}elseif( tie_get_option( 'time_format' ) == 'modern' ){

		$time_now  = current_time('timestamp');
		$post_time = get_the_time('U') ;

		if ( $post_time > $time_now - ( 60 * 60 * 24 * 30 ) ) {
			$since = sprintf( __ti( '%s ago' ), human_time_diff( $post_time, $time_now ) );
		} else {
			$since = get_the_time(get_option('date_format'));
		}

	}else{
		$since = get_the_time(get_option('date_format'));
	}

	$post_time = '<span class="tie-date"><i class="fa fa-clock-o"></i>'.$since.'</span>';

	if( $return ){
		return $post_time;
	}else{
		echo $post_time;
	}
}
/*-----------------------------------------------------------------------------------*/
# Posts Classes
/*-----------------------------------------------------------------------------------*/
function tie_post_class( $classes = false ) {
    global $post;

	$post_format = get_post_meta($post->ID, 'tie_post_head', true);
	if( !empty($post_format) ){
		if( !empty($classes) ) $classes .= ' ';
		$classes .= 'tie_'.$post_format;
	}
	if( !empty($classes) )
		echo 'class="'.$classes.'"';
}

function tie_get_post_class( $classes = false ) {
    global $post;

	$post_format = get_post_meta($post->ID, 'tie_post_head', true);
	if( !empty($post_format) ){
		if( !empty($classes) ) $classes .= ' ';
		$classes .= 'tie_'.$post_format;
	}
	if( !empty($classes) )
		return 'class="'.$classes.'"';
}


/* Old Review Shortcode */
add_shortcode('review', 'taqyeem_shortcode_review');

?>
