<?php
class Questions extends \Elementor\Widget_Base {


	public function get_name() {
		return 'questions';
	}

	public function get_title() {
		return __( 'questions list', 'negarin' );
	}

	public function get_icon() {
		return 'eicon-plus-square-o';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}
	public function get_script_depends() {
		return [ 'elementor-hello-world' ];
	}
	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'General', 'negarin' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'title', 'negarin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title',
			]
        );
        $this->add_control(
			'grid_style',
			[
			  'label' => __( 'Grid Style', 'negarin' ),
			  'type' => \Elementor\Controls_Manager::SELECT,
			  'default' => '1',
			  'options' => [
				'1' => esc_html__( 'Layout 1', 'negarin' ),
				'2' => esc_html__( 'Layout 2', 'negarin' ),
			  ],
			]
		  );
        $this->end_controls_section();
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'negarin' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'negarin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'negarin' ),
				'label_block' => true,
			]
        );
        $repeater->add_control(
			'mor_title', [
				'label' => __( 'Title more', 'negarin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Title more' , 'negarin' ),
				'label_block' => true,
			]
        );
        $repeater->add_control(
			'des_title', [
                'label' => __( 'Description', 'negarin' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __( 'Default description', 'negarin' ),
                'placeholder' => __( 'Type your description here', 'negarin' ),
                
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'negarin' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
        );
        $repeater->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'negarin' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
        );
        $repeater->add_control(
			'website_link',
			[
				'label' => __( 'Link', 'negarin' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'negarin' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'negarin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Title #1', 'negarin' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
					],
					[
						'list_title' => __( 'Title #2', 'negarin' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();
     
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'negarin' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'color',
			[
				'label' => __( 'Title Color', 'negarin' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00bfd6',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_2',
			[
				'label' => __( 'Title Color', 'negarin' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2a2a2a',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $grid_style = $settings['grid_style'];
            if( 2 == $grid_style ){
                include( __DIR__ . '/template/questions/layout-2.php' );
              }else{
                include( __DIR__ . '/template/questions/layout-1.php' );
              }
                wp_reset_postdata();
	}

}
