<?php
class Products_Categories extends \Elementor\Widget_Base {

	public function get_name() {
		return 'products-categories';
	}

	public function get_title() {
		return __( 'products categories', 'negarin' );
	}

	public function get_icon() {
		return 'eicon-product-categories';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}
	public function get_script_depends() {
		return [ 'elementor-hello-world' ];
	}

	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'General', 'negarin' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'title', 'negarin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title',
			]
        );
        $this->end_controls_section();
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'negarin' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'negarin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'negarin' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'number',
			[
				'label' => __( 'number', 'negarin' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 300,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'negarin' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
        );
        $repeater->add_control(
			'website_link',
			[
				'label' => __( 'Link', 'negarin' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'negarin' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'negarin' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Title #1', 'negarin' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
					],
					[
						'list_title' => __( 'Title #2', 'negarin' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();
     
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'negarin' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'color',
			[
				'label' => __( 'Title Color', 'negarin' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00bfd6',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_2',
			[
				'label' => __( 'Title Color', 'negarin' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2a2a2a',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();


	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        if ( $settings['list'] ) { ?>
            <div class="container">
            <div class="woo-promotion__categories_container">
                <div class="woo-promotion__categories-title"><?php echo $settings['title'] ?></div>
                <div class="woo-promotion__categories">
                <?php foreach (  $settings['list'] as $item ) { 
                    echo '<li title="' . $settings['title'] . '"><a class="woo-promotion__category" style="color:' . $settings['color'] . '" href="' . $item['website_link']['url'] . '">';
               		 \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <div class="woo-promotion__category-name" style="color: <?php echo $settings['title_color_2']; ?>">
                    <?php echo $item['list_title'] ?>
                    </div>
                    <div class="woo-promotion__category-quantity">
                    <?php echo $item['number'] ?>
                    </div>
                </a></li>
                <?php } ?>
                </div>
			</div>
            </div>
        <?php
		}
	}

}
