<?php
class Amazing_Offer extends \Elementor\Widget_Base {
	public function get_name() {
		return 'amazing-offer';
	}

	public function get_title() {
		return __( 'amazing offer', 'negarin' );
	}

	public function get_icon() {
		return 'eicon-product-upsell';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}
  public function get_script_depends()
	{
		return ['elementor-hello-world'];
	}

	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
	{
		$this->start_controls_section(
			'section_content',
			[
				'label' => __('Content', 'negarin'),
			]
		);
		$this->add_control(
			'grid_style',
			[
				'label' => __('Grid Style', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__('Layout 1', 'negarin'),
					'2' => esc_html__('Layout 2', 'negarin'),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __('Title', 'negarin'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Edible and drinkable',
			]
		);
		$this->add_control(
			'title_show_more',
			[
				'label' => __('title show more', 'negarin'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'View all offers',
			]
		);
		$this->add_control(
			'more_link',
			[
				'label' => __('more Link', 'negarin'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'negarin'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'des_title', [
                'label' => __( 'Description', 'negarin' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __( 'Default description', 'negarin' ),
                'placeholder' => __( 'Type your description here', 'negarin' ),
                
			]
		);
		$this->add_control(
			'countdown',
			[
				'label' => __('countdown', 'negarin'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'negarin'),
				'label_off' => __('Hide', 'negarin'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_Icon',
			[
				'label' => __('Icon', 'negarin'),
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => __('Icon', 'negarin'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->add_control(
			'icon_text',
			[
				'label' => __('Icon text', 'negarin'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-stopwatch',
					'library' => 'solid',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'negarin-products',
			[
				'label' => esc_html__('Product Settings', 'negarin'),
			]
		);
		$this->add_control(
			'my_plugin_product_grid_product_filter',
			[
				'label' => esc_html__('Filter By', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'recent',
				'options' => [
					'recent' => esc_html__('Recent Products', 'negarin'),
					'featured' => esc_html__('Featured Products', 'negarin'),
					'best_selling' => esc_html__('Best Selling Products', 'negarin'),
					'sale' => esc_html__('Sale Products', 'negarin'),
					'top_rated' => esc_html__('Top Rated Products', 'negarin'),
					'mixed_order' => esc_html__('Mixed order Products', 'negarin'),
				],
			]
		);
		$this->add_control(
			'my_plugin_product_grid_products_count',
			[
				'label'   => __('Products Count', 'negarin'),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 5,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);

		$this->add_control(
			'my_plugin_product_grid_categories',
			[
				'label' => esc_html__('Product Categories', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => my_plugin_taxonomy_list(),
			]
		);

		$this->add_control(
			'custom_order',
			[
				'label' => esc_html__('Custom order', 'negarin'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => esc_html__('Orderby', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'          => esc_html__('None', 'negarin'),
					'ID'            => esc_html__('ID', 'negarin'),
					'date'          => esc_html__('Date', 'negarin'),
					'name'          => esc_html__('Name', 'negarin'),
					'title'         => esc_html__('Title', 'negarin'),
					'comment_count' => esc_html__('Comment count', 'negarin'),
					'rand'          => esc_html__('Random', 'negarin'),
				],
				'condition' => [
					'custom_order' => 'yes',
				]
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__('order', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC'  => esc_html__('Descending', 'negarin'),
					'ASC'   => esc_html__('Ascending', 'negarin'),
				],
				'condition' => [
					'custom_order' => 'yes',
				]
			]
		);

		$this->end_controls_section();
		/*
		$this->start_controls_section(
            'content_section_h',
            [
              'label' => __( 'option slide', 'negarin' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
          );
            $this->add_control(
              'autoplay_ama',
              [
                'label' => __( 'auto play', 'negarin' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'true', 'negarin' ),
                'label_off' => __( 'false', 'negarin' ),
                'return_value' => 'yes',
                'default' => 'yes',
              ]
            );
            $this->add_control(
              'autoplayTimeout',
              [
                'label' => __( 'auto play Time out', 'negarin' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 5,
                'max' => 10000,
                'step' => 5,
                'default' => 5000,
              ]
            );
            $this->add_control(
              'navext_ama',
              [
                'label' => __( 'nav', 'negarin' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'true', 'negarin' ),
                'label_off' => __( 'false', 'negarin' ),
                'return_value' => 'yes',
                'default' => 'yes',
              ]
            );
          $this->end_controls_section();
			*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => __('Style', 'negarin'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'background_color',
			[
				'label' => __('background color', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_1',
			[
				'label' => __('Title Color', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_2',
			[
				'label' => __('Title Color 2', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_3',
			[
				'label' => __('Title Color 3', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_4',
			[
				'label' => __('color show more', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_5',
			[
				'label' => __('color show more mobile', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#212121',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render(){ 
		?>
	
		<script>
      $(document).ready(function() {
var sync1 = $("#sync1");
var sync2 = $("#sync2");
var slidesPerPage = 4; //globaly define number of elements per page
var syncedSecondary = true;

sync1.owlCarousel({
    rtl: true,
    items: 1,
    slideSpeed: 2000,
    nav: false,
    dots: false,
    loop: true,
	autoplay:true,
    autoplayTimeout:6000,
    autoplayHoverPause:true,
	navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
}).on('changed.owl.carousel', syncPosition);
$('.play').on('click',function(){
    owl.trigger('play.owl.autoplay',[1000])
})
$('.stop').on('click',function(){
    owl.trigger('stop.owl.autoplay')
})
sync2
    .on('initialized.owl.carousel', function() {
        sync2.find(".owl-item").eq(0).addClass("current");
    })
    .owlCarousel({
        rtl: true,
        items: slidesPerPage,
        dots: true,
        nav: false,
        smartSpeed: 500,
        slideSpeed: 500,
		navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
        slideBy: slidesPerPage, //alternatively you can slide by 1, this way the active slide will stick to the first item in the second carousel
        responsiveRefreshRate: 100
    }).on('changed.owl.carousel', syncPosition2);

function syncPosition(el) {

    var count = el.item.count - 2;
    var current = Math.round(el.item.index - (el.item.count / 2) - .6);

    if (current < 0) {
        current = count;
    }
    if (current > count) {
        current = 0;
    }

    //end block

    sync2
        .find(".owl-item")
        .removeClass("current")
        .eq(current)
        .addClass("current");
    var onscreen = sync2.find('.owl-item.active').length - 1;
    var start = sync2.find('.owl-item.active').first().index();
    var end = sync2.find('.owl-item.active').last().index();

    if (current > end) {
        sync2.data('owl.carousel').to(current, 100, true);
    }
    if (current < start) {
        sync2.data('owl.carousel').to(current - onscreen, 100, true);
    }
}

function syncPosition2(el) {
    if (syncedSecondary) {
        var number = el.item.index;
        sync1.data('owl.carousel').to(number, 100, true);
    }
}

sync2.on("click", ".owl-item", function(e) {
    e.preventDefault();
    var number = $(this).index();
    sync1.data('owl.carousel').to(number, 300, true);
});
});
</script>
		<?php
		$settings = $this->get_settings_for_display();
		$settings           = $this->get_settings_for_display();
		$product_type       = $this->get_settings_for_display('my_plugin_product_grid_product_filter');
		$per_page           = $this->get_settings_for_display('my_plugin_product_grid_products_count');
		$custom_order_ck    = $this->get_settings_for_display('custom_order');
		$orderby            = $this->get_settings_for_display('orderby');
		$order              = $this->get_settings_for_display('order');
		$tabuniqid          = $this->get_id();
		$proslider          = $this->get_settings_for_display('proslider');
		$producttab          = $this->get_settings_for_display('producttab');
		$grid_style = $settings['grid_style'];
		$bg_image = '';
		$bg_image_mobile = '';
		// WooCommerce Category
		$args = array(
			'post_type'             => 'product',
			'post_status'           => 'publish',
			'ignore_sticky_posts'   => 1,
			'posts_per_page'        => $per_page,
		);
		// background image 
		if (!empty($settings['bg_image']['id'])) {
			$bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
		} elseif (!empty($settings['bg_image']['url'])) {
			$bg_image = $settings['bg_image']['url'];
		}
		$this->add_render_attribute('background_image', 'style', [
			'background-image: url(' . $bg_image . ');',
		]);
		// background image mobile
		if (!empty($settings['bg_image_mobile']['id'])) {
			$bg_image_mobile = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image_mobile']['id'], 'bg_image_mobile', $settings);
		} elseif (!empty($settings['bg_image_mobile']['url'])) {
			$bg_image_mobile = $settings['bg_image_mobile']['url'];
		}
		$this->add_render_attribute('background_image_mobile', 'style', [
			'background-image: url(' . $bg_image_mobile . ');',
		]);
		switch ($product_type) {

			case 'sale':
				$args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
				break;

			case 'featured':
				$args['tax_query'][] = array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'featured',
					'operator' => 'IN',
				);
				break;

			case 'best_selling':
				$args['meta_key']   = 'total_sales';
				$args['orderby']    = 'meta_value_num';
				$args['order']      = 'desc';
				break;

			case 'top_rated':
				$args['meta_key']   = '_wc_average_rating';
				$args['orderby']    = 'meta_value_num';
				$args['order']      = 'desc';
				break;

			case 'mixed_order':
				$args['orderby']    = 'rand';
				break;

			default: /* Recent */
				$args['orderby']    = 'date';
				$args['order']      = 'desc';
				break;
		}

		// Custom Order
		if ($custom_order_ck == 'yes') {
			$args['orderby'] = $orderby;
			$args['order'] = $order;
		}

		$get_product_categories = $settings['my_plugin_product_grid_categories']; // get custom field value
		$product_cats = str_replace(' ', '', $get_product_categories);

		if ("0" != $get_product_categories) {
			if (is_array($product_cats) && count($product_cats) > 0) {
				$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
				$args['tax_query'][] = array(
					array(
						'taxonomy' => 'product_cat',
						'terms' => $product_cats,
						'field' => $field_name,
						'include_children' => false
					)
				);
			}
		}

		$products = new \WP_Query($args);
		if ($producttab == 'yes') {
			$m = 0;
			if (is_array($product_cats) && count($product_cats) > 0) {

				// Category retrive
				$catargs = array(
					'orderby'    => 'name',
					'order'      => 'ASC',
					'hide_empty' => true,
					'slug'       => $product_cats,
				);
				$prod_categories = get_terms('product_cat', $catargs);

				foreach ($prod_categories as $prod_cats) {
					$m++;
					$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
					$args['tax_query'] = array(
						array(
							'taxonomy' => 'product_cat',
							'terms' => $prod_cats,
							'field' => $field_name,
							'include_children' => false
						),
					);
					if ('featured' == $product_type) {
						$args['tax_query'][] = array(
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
							'operator' => 'IN',
						);
					}
				}
			}
		};
		if (is_array($product_cats) && (count($product_cats) > 0) && ($producttab == 'yes')) :
			$j = 0;
			foreach ($product_cats as $cats) :
				$j++;
				$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'product_cat',
						'terms' => $cats,
						'field' => $field_name,
						'include_children' => false
					)
				);
				if ('featured' == $product_type) {
					$args['tax_query'][] = array(
						'taxonomy' => 'product_visibility',
						'field'    => 'name',
						'terms'    => 'featured',
						'operator' => 'IN',
					);
				}
				$products = new \WP_Query($args);

				if ($products->have_posts()) :
				endif;
			endforeach;  else :

			$k = 1;
			if ($products->have_posts()) :
				if (1 == $grid_style) {

					include(__DIR__ . '/template/offer/offer-1.php');
				} elseif (2 == $grid_style) {

					include(__DIR__ . '/template/offer/offer-2.php');
				}  else {

					include(__DIR__ . '/template/offer/offer-1.php');
				}
				wp_reset_postdata();
			endif;
		endif;
	}
}
