<!DOCTYPE html>
<html lang="fa">

<head>
  <meta charset="<?php bloginfo('charset'); ?>" />
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS2 Feed" href="<?php bloginfo('rss2_url'); ?>" />
  <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
  <?php
  wp_head();
  load_theme_textdomain('negarin'); ?>
  <meta name="theme-color" content="#fff" />
  <style>
    .container,
    .container-fluid {
      max-width: 1500px;
    }
  </style>
</head>

<body <?php body_class(); ?> id="body_shop">
  <?php global $woocommerce; ?>
  <?php global $product;
  // select header single product
  if (is_product()) :
    get_template_part('themeplat/navbar/select-nav', 'navbarshop');
  endif;
  ?>
  <div id="back-to-topd" class="sticky_toolbox active back_to_top">
    <ul>
      <?php
      $display_notification_back  = ot_get_option('display_notification_back', true);
      if ($display_notification_back  == 'on') :
      ?>
        <li>
          <div class="open-button">
            <a href="#" id="showbar" title="<?php _e('notification', 'negarin'); ?>">
              <i class="fal fa-bell"></i>
              <span id="toolbox_cart" style="background: #f93636">
                <div class="header-cart-count">1</div>
              </span>
            </a>
          </div>
        </li>
      <?php
      endif;
      $display_call_back  = ot_get_option('display_call_back', true);
      if ($display_call_back  == 'on') :
      ?>
        <li>
          <a target="block" href="<?php echo ot_get_option('link_call_back_to_top'); ?>" class="compare_sticky" title="<?php echo ot_get_option('text_call_back_to_top', 'تماس'); ?>">
            <i class="fal fa-headset"></i>
          </a>
        </li>
      <?php
      endif;
      $display_cart_back  = ot_get_option('display_cart_back', true);
      if ($display_cart_back  == 'on') :
      ?>
        <li>
          <a href="<?php echo wc_get_cart_url(); ?>" title="<?php _e('cart', 'negarin'); ?>">
            <i class=" fal fa-shopping-bag"></i>
            <span id="toolbox_cart">
              <div class="header-cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></div>
            </span>
          </a>
        </li>
      <?php
      endif;
      $display_back_to_top  = ot_get_option('display_back_to_top', true);
      if ($display_back_to_top  == 'on') :
      ?>
        <li>
          <a href="#" id="scroll" class="gototop" title="<?php _e('back to top', 'negarin'); ?>"><i class="fal fa-arrow-up"></i></a>
        </li>
      <?php endif; ?>
    </ul>
  </div>
  <div data-ml-modal id="modal-11">
    <a href="#!" class="modal-overlay"></a>
    <div class="modal-dialog modal-dialog-lg">
      <?php get_template_part('themeplat-part/single-product/product-icon-box', 'product-icon-box'); ?>
    </div>
  </div>