<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 7.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="product-serchform-wc">
<form id="searches" name="product-search" method="get" action="<?php echo esc_url (home_url ()); ?>" >
	<div class="category-searchform">
		<i class="fal fa-sliders-v"></i>
	</div>
	<?php $categories = get_product_categories_hierarchy(); ?>
        <?php if ($categories): ?>
            <select name="category" id="cat" class="category postform">
                <option class="default" value=""><?php echo esc_html__( 'Select a category', 'negarin' ); ?></option>
            <?php list_taxonomy_hierarchy_no_instance( $categories); ?>
        </select>
    <?php endif ?>
    <div class="search-wrapper">
		<input id="lsds" type="search" name="s" class="search" value="<?php echo get_search_query(); ?>" placeholder="<?php echo esc_attr_x( 'نام محصول مورد نظر ...', 'placeholder', 'woocommerce' ); ?>" maxlength="50" required="required">
		<button type="submit" class="submit_button" value="<?php echo esc_attr_x( 'Search', 'submit button', 'woocommerce' ); ?>"><?php echo esc_html_x( 'Search', 'submit button', 'woocommerce' ); ?><i class="fal fa-search"></i></button>
            <div class="loader_theme">
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            </div>
		<input type="hidden" name="post_type" value="product" />
    </div>
    </form>
    <div class="search-results-product"></div>
</div>


