<?php
add_action('admin_menu', 'negarin_add_metabox');

function negarin_add_metabox()
{

    add_meta_box(
        'negarin_metabox', // metabox ID
        __('header', 'negarin'),
        'negarin_metabox_callback', // callback function
        ['post', 'page', 'product'], // post type or post types in array
        'side', // position (normal, side, advanced)
        'default' // priority (default, low, high, core)
    );
}


function negarin_metabox_callback($post)
{

    $seo_title = get_post_meta($post->ID, 'seo_title', true);
    $seo_robots = get_post_meta($post->ID, 'seo_robots', true);

    // nonce, actually I think it is not necessary here
    wp_nonce_field('somerandomstr', '_negarinnonce'); ?>
    <table class="form-table">
        <tbody>
            <!--
            <tr>
                <th><label for="seo_title">SEO title</label></th>
                <td><input type="text" id="seo_title" name="seo_title" value="<?php esc_attr($seo_title); ?>" class="regular-text"></td>
            </tr>
-->
            <tr>
                <th><label for="seo_tobots"><?php _e('select header', 'negarin'); ?></label></th>
                <td>
                    <select id="seo_robots" name="seo_robots">
                        <option value="">Select...</option>
                        <option value="header_1" <?php selected(' header_1', $seo_robots, false); ?>><?php _e('header 1', 'negarin'); ?></option>
                        <option value="header_2" <?php selected('header_2', $seo_robots, false); ?>><?php _e('header 2', 'negarin'); ?></option>
                        <option value="header_3" <?php selected('header_3', $seo_robots, false); ?>><?php _e('header 3', 'negarin'); ?></option>
                        <option value="header_4" <?php selected('header_4', $seo_robots, false); ?>><?php _e('header 4', 'negarin'); ?></option>
                        <option value="header_5" <?php selected('header_5', $seo_robots, false); ?>><?php _e('header 5', 'negarin'); ?></option>
                    </select>
                </td>
            </tr>
        </tbody>
    </table>
<?php
}
add_action('save_post', 'negarin_save_meta', 10, 2);
add_action('save_post', 'negarin_save_metap', 10, 2);
add_action('save_post', 'negarin_save_metapr', 10, 2);
function negarin_save_meta($post_id, $post)
{

    // nonce check
    if (!isset($_POST['_negarinnonce']) || !wp_verify_nonce($_POST['_negarinnonce'], 'somerandomstr')) {
        return $post_id;
    }

    // check current use permissions
    $post_type = get_post_type_object($post->post_type);

    if (!current_user_can($post_type->cap->edit_post, $post_id)) {
        return $post_id;
    }

    // Do not save the data if autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }

    // define your own post type here
    $slug = "page";
    if ($slug != $post->post_type) {
        return $post_id;
    }
    if (isset($_POST['seo_title'])) {
        update_post_meta($post_id, 'seo_title', sanitize_text_field($_POST['seo_title']));
    } else {
        delete_post_meta($post_id, 'seo_title');
    }
    if (isset($_POST['seo_robots'])) {
        update_post_meta($post_id, 'seo_robots', sanitize_text_field($_POST['seo_robots']));
    } else {
        delete_post_meta($post_id, 'seo_robots');
    }

    return $post_id;
}
function negarin_save_metap($post_id, $post)
{

    // nonce check
    if (!isset($_POST['_negarinnonce']) || !wp_verify_nonce($_POST['_negarinnonce'], 'somerandomstr')) {
        return $post_id;
    }

    // check current use permissions
    $post_type = get_post_type_object($post->post_type);

    if (!current_user_can($post_type->cap->edit_post, $post_id)) {
        return $post_id;
    }

    // Do not save the data if autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }

    // define your own post type here
    $slug = "post";
    if ($slug != $post->post_type) {
        return $post_id;
    }
    if (isset($_POST['seo_title'])) {
        update_post_meta($post_id, 'seo_title', sanitize_text_field($_POST['seo_title']));
    } else {
        delete_post_meta($post_id, 'seo_title');
    }
    if (isset($_POST['seo_robots'])) {
        update_post_meta($post_id, 'seo_robots', sanitize_text_field($_POST['seo_robots']));
    } else {
        delete_post_meta($post_id, 'seo_robots');
    }

    return $post_id;
}
function negarin_save_metapr($post_id, $post)
{

    // nonce check
    if (!isset($_POST['_negarinnonce']) || !wp_verify_nonce($_POST['_negarinnonce'], 'somerandomstr')) {
        return $post_id;
    }

    // check current use permissions
    $post_type = get_post_type_object($post->post_type);

    if (!current_user_can($post_type->cap->edit_post, $post_id)) {
        return $post_id;
    }

    // Do not save the data if autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }

    // define your own post type here
    $slug = "product";
    if ($slug != $post->post_type) {
        return $post_id;
    }
    if (isset($_POST['seo_title'])) {
        update_post_meta($post_id, 'seo_title', sanitize_text_field($_POST['seo_title']));
    } else {
        delete_post_meta($post_id, 'seo_title');
    }
    if (isset($_POST['seo_robots'])) {
        update_post_meta($post_id, 'seo_robots', sanitize_text_field($_POST['seo_robots']));
    } else {
        delete_post_meta($post_id, 'seo_robots');
    }

    return $post_id;
}
