<?php
class Products_Iist extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'products-list';
	}

	public function get_title()
	{
		return __('products list', 'negarin');
	}

	public function get_icon()
	{
		return 'eicon-gallery-masonry';
	}

	public function get_categories()
	{
		return ['elementor-widget-be-shop'];
	}
	public function get_script_depends()
	{
		return ['elementor-hello-world'];
	}

	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
	{
		$this->start_controls_section(
			'section_content',
			[
				'label' => __('Content', 'negarin'),
			]
		);
		$this->add_control(
			'grid_style',
			[
				'label' => __('Grid Style', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__('Layout 1', 'negarin'),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __('Title', 'negarin'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Edible and drinkable',
			]
		);
		$this->add_control(
			'title_show_more',
			[
				'label' => __('title show more', 'negarin'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'View all offers',
			]
		);
		$this->add_control(
			'more_link',
			[
				'label' => __('more Link', 'negarin'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'negarin'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'icon_show_more',
			[
				'label' => __('Icon show more', 'negarin'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->add_control(
			'image_title',
			[
				'label' => __('Choose Image title', 'negarin'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label' => __('Choose Image background', 'negarin'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'bg_image', // Actually its `image_size`
				'label' => __('Image Resolution', 'negarin'),
				'default' => 'full',
				'condition' => [
					'bg_image[id]!' => '',
				],
				'separator' => 'none',
			]

		);
		$this->add_control(
			'countdown',
			[
				'label' => __('countdown', 'negarin'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'negarin'),
				'label_off' => __('Hide', 'negarin'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_header',
			[
				'label' => __('header', 'negarin'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'negarin'),
				'label_off' => __('Hide', 'negarin'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'grid_pagination',
			[
				'label' => __('pagination', 'negarin'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'negarin'),
				'label_off' => __('Hide', 'negarin'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_add_to_cart',
			[
				'label' => __('add to cart', 'negarin'),
			]
		);
		$this->add_control(
			'title_add_to_cart',
			[
				'label' => __('Title', 'negarin'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('add to cart', 'negarin'),
			]
		);
		$this->add_control(
			'cart_tools',
			[
				'label' => __('add to cart', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '2',
				'options' => [
					'1' => esc_html__('hid', 'negarin'),
					'2' => esc_html__('cart', 'negarin'),
					'3' => esc_html__('cart advanced', 'negarin'),
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'negarin-products',
			[
				'label' => esc_html__('Product Settings', 'negarin'),
			]
		);
		$this->add_control(
			'my_plugin_product_grid_product_filter',
			[
				'label' => esc_html__('Filter By', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'recent',
				'options' => [
					'recent' => esc_html__('Recent Products', 'negarin'),
					'featured' => esc_html__('Featured Products', 'negarin'),
					'best_selling' => esc_html__('Best Selling Products', 'negarin'),
					'sale' => esc_html__('Sale Products', 'negarin'),
					'top_rated' => esc_html__('Top Rated Products', 'negarin'),
					'mixed_order' => esc_html__('Mixed order Products', 'negarin'),
				],
			]
		);
		$this->add_control(
			'my_plugin_product_grid_products_count',
			[
				'label'   => __('Products Count', 'negarin'),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);

		$this->add_control(
			'my_plugin_product_grid_categories',
			[
				'label' => esc_html__('Product Categories', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => my_plugin_taxonomy_list(),
			]
		);

		$this->add_control(
			'custom_order',
			[
				'label' => esc_html__('Custom order', 'negarin'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => esc_html__('Orderby', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'          => esc_html__('None', 'negarin'),
					'ID'            => esc_html__('ID', 'negarin'),
					'date'          => esc_html__('Date', 'negarin'),
					'name'          => esc_html__('Name', 'negarin'),
					'title'         => esc_html__('Title', 'negarin'),
					'comment_count' => esc_html__('Comment count', 'negarin'),
					'rand'          => esc_html__('Random', 'negarin'),
				],
				'condition' => [
					'custom_order' => 'yes',
				]
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__('order', 'negarin'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC'  => esc_html__('Descending', 'negarin'),
					'ASC'   => esc_html__('Ascending', 'negarin'),
				],
				'condition' => [
					'custom_order' => 'yes',
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_style',
			[
				'label' => __('Style', 'negarin'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color_1',
			[
				'label' => __('Title Color', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'color_cover',
			[
				'label' => __('color cover', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'red',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_color_4',
			[
				'label' => __('color show more', 'negarin'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ef5661',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$settings           = $this->get_settings_for_display();
		$product_type       = $this->get_settings_for_display('my_plugin_product_grid_product_filter');
		$per_page           = $this->get_settings_for_display('my_plugin_product_grid_products_count');
		$custom_order_ck    = $this->get_settings_for_display('custom_order');
		$orderby            = $this->get_settings_for_display('orderby');
		$order              = $this->get_settings_for_display('order');
		$tabuniqid          = $this->get_id();
		$proslider          = $this->get_settings_for_display('proslider');
		$producttab          = $this->get_settings_for_display('producttab');
		$grid_style = $settings['grid_style'];
		$cart_tools = $settings['cart_tools'];
		$bg_image = '';
		// WooCommerce Category
		$args = array(
			'post_type'             => 'product',
			'post_status'           => 'publish',
			'ignore_sticky_posts'   => 1,
			'posts_per_page'        => $per_page,
		);
		if (!empty($settings['bg_image']['id'])) {
			$bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['bg_image']['id'], 'bg_image', $settings);
		} elseif (!empty($settings['bg_image']['url'])) {
			$bg_image = $settings['bg_image']['url'];
		}
		$this->add_render_attribute('background_image', 'style', [
			'background-image: url(' . $bg_image . ');',
		]);
		switch ($product_type) {

			case 'sale':
				$args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
				break;

			case 'featured':
				$args['tax_query'][] = array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'featured',
					'operator' => 'IN',
				);
				break;

			case 'best_selling':
				$args['meta_key']   = 'total_sales';
				$args['orderby']    = 'meta_value_num';
				$args['order']      = 'desc';
				break;

			case 'top_rated':
				$args['meta_key']   = '_wc_average_rating';
				$args['orderby']    = 'meta_value_num';
				$args['order']      = 'desc';
				break;

			case 'mixed_order':
				$args['orderby']    = 'rand';
				break;

			default: /* Recent */
				$args['orderby']    = 'date';
				$args['order']      = 'desc';
				break;
		}

		// Custom Order
		if ($custom_order_ck == 'yes') {
			$args['orderby'] = $orderby;
			$args['order'] = $order;
		}

		$get_product_categories = $settings['my_plugin_product_grid_categories']; // get custom field value
		$product_cats = str_replace(' ', '', $get_product_categories);

		if ("0" != $get_product_categories) {
			if (is_array($product_cats) && count($product_cats) > 0) {
				$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
				$args['tax_query'][] = array(
					array(
						'taxonomy' => 'product_cat',
						'terms' => $product_cats,
						'field' => $field_name,
						'include_children' => false
					)
				);
			}
		}

		$products = new \WP_Query($args);
		if ($producttab == 'yes') {
			$m = 0;
			if (is_array($product_cats) && count($product_cats) > 0) {

				// Category retrive
				$catargs = array(
					'orderby'    => 'name',
					'order'      => 'ASC',
					'hide_empty' => true,
					'slug'       => $product_cats,
				);
				$prod_categories = get_terms('product_cat', $catargs);

				foreach ($prod_categories as $prod_cats) {
					$m++;
					$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
					$args['tax_query'] = array(
						array(
							'taxonomy' => 'product_cat',
							'terms' => $prod_cats,
							'field' => $field_name,
							'include_children' => false
						),
					);
					if ('featured' == $product_type) {
						$args['tax_query'][] = array(
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
							'operator' => 'IN',
						);
					}
				}
			}
		};
		if (is_array($product_cats) && (count($product_cats) > 0) && ($producttab == 'yes')) :
			$j = 0;
			foreach ($product_cats as $cats) :
				$j++;
				$field_name = is_numeric($product_cats[0]) ? 'term_id' : 'slug';
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'product_cat',
						'terms' => $cats,
						'field' => $field_name,
						'include_children' => false
					)
				);
				if ('featured' == $product_type) {
					$args['tax_query'][] = array(
						'taxonomy' => 'product_visibility',
						'field'    => 'name',
						'terms'    => 'featured',
						'operator' => 'IN',
					);
				}
				$products = new \WP_Query($args);

				if ($products->have_posts()) :
?>
			<?php endif;
			endforeach; ?>

		<?php else : ?>
			<!-- Set up your HTML -->
<?php
			$k = 1;
			if ($products->have_posts()) :
				if (1 == $grid_style) {

					include(__DIR__ . '/template/product-list-tm.php');
				}
				wp_reset_postdata();
			endif;
		endif;
	}
}
